#! /usr/bin/python
#
# Utility command to mirror all (local) repositories to external
#
#  Utilize something like this, ahead of time, to cache https credentials...
#  git config --global credential.helper cache
#  git config --global credential.https://vadev.mantech.com darmbrust

import subprocess







projects = ['ISAAC-developer-docs',
			'ISAAC',
			'ISAAC-term-convert-cpt',
			'ISAAC-term-convert-cvx',
			'ISAAC-term-convert-nucc',
			'ISAAC-term-convert-hl7v3',
			'ISAAC-term-convert-icd10',
			'ISAAC-term-convert-rf2',
			'ISAAC-term-convert-vhat',
			'ISAAC-term-convert-loinc',
			'ISAAC-term-convert-mvx',
			'ISAAC-term-convert-rxnorm',
			'ISAAC-term-convert-sopt',
			'ISAAC-db-builder-solor',
			'ISAAC-db-builder-vhat',
			'ISAAC-db-builder-vets',
			'ISAAC-fx-gui',
			'ISAAC-fx-gui-pa',
			'ISAAC-rest',
			'ISAAC-file-transfer-utils',
			'rails_common',
			'rails_komet',
			'rails_prisme',
			'VUID-rest',
			'apache_extensions',
			'aitc_install']

def git(*args):
	return subprocess.check_call(['git'] + list(args))

#remoteBaseURL = 'https://daniel_armbrust@bitbucket.org/sagebits/'
remoteBaseURL2 = 'https://daniel_armbrust@bitbucket.org/vacttdm/'
#remoteBaseURL = 'https://darmbrust@vadev.mantech.com:4848/git/r/'

for project in projects:
	print("==================================")
	print("Mirror Push " + project)
#	git("-C", project, "push", "--all",  remoteBaseURL + project + ".git")
#	git("-C", project, "push", "--tags",  remoteBaseURL + project + ".git")
	git("-C", project, "push", "--all",  remoteBaseURL2 + project + ".git")
	git("-C", project, "push", "--tags",  remoteBaseURL2 + project + ".git")
	print("==================================")
	print("");
